
import os
import random
import subprocess

def main():
    # Ensure the output directory exists
    os.makedirs("instances", exist_ok=True)

    # random.seed(12345)

    for i in range(1, 51):
        num_curbs = random.choice([4, 5])
        # Compute number of cars = (num_curbs - 2) * 2
        num_cars = (num_curbs - 2) * 2

        mode = "seq"  # or "seq"

        # Optionally pick a random seed so each problem differs
        seed = random.randint(1, 999999999)
        base_name = f"problem_{i}"

        # Build the command
        cmd = [
            "perl",
            ".<PATH_REMOVED>",
            base_name,
            str(num_curbs),
            str(num_cars),
            mode,
            str(seed)
        ]

        # Run the Perl script and capture its stdout
        result = subprocess.run(cmd, capture_output=True, text=True, check=True)

        # Save the generated PDDL into "instances/problem_{id}.pddl"
        output_filename = f"instances/instance-{i}.pddl"
        with open(output_filename, "w") as f:
            f.write(result.stdout)

        print(f"Generated {output_filename} with {num_curbs} curbs and {num_cars} cars.")

if __name__ == "__main__":
    main()
